<?php
/**
 * Plugin Name: HR Management
 * Description: A complete HR Management system.
 * Version: 2.4
 * Author: ByteBrew Technology
 */

defined( 'ABSPATH' ) || exit;

// Define Constants
define( 'HRM_PLUGIN_FILE', __FILE__ );
define( 'HRM_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'HRM_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Include Core Files
require_once HRM_PLUGIN_PATH . 'includes/hrm-setup.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-security.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-dashboard.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-employees.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-attendance.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-tasks.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-leave.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-reports.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-notifications.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-portal.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-policies.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-payroll.php';
// Test Mode removed - require_once HRM_PLUGIN_PATH . 'includes/hrm-test-mode.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-ui-helper.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-icons.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-pagination.php';
require_once HRM_PLUGIN_PATH . 'includes/hrm-ip-config.php';

// Initialize
function hrm_init_plugin() {
    HRM_Security::init();
    HRM_Setup::init();
    HRM_Dashboard::init();
    HRM_Employees::init();
    HRM_Attendance::init();
    HRM_Tasks::init();
    HRM_Leave::init();
    HRM_Reports::init();
    HRM_Notifications::init();
    HRM_Portal::init();
    HRM_Policies::init();
    HRM_Payroll::init();
    HRM_IP_Config::init();
    // Test Mode removed - HRM_Test_Mode::init();
}
add_action( 'plugins_loaded', 'hrm_init_plugin' );

// Activation Hook
register_activation_hook( __FILE__, [ 'HRM_Setup', 'activate_plugin' ] );
